ORCA/M Asm65816 2.1.0

0001 2D92                       title 'QD Rects             GS ROM 2.0' 
0002 2D92              ****************************************************************
0003 2D92              *                                                              *
0004 2D92              *              RECTS                                           *
0005 2D92              *                                                              *
0006 2D92              ****************************************************************
0007 2D92
0008 2D92
0009 2D92              ****************************************************************
0010 2D92              *                                                              *
0011 2D92              *                  Copyright (C) 1985-1990                     *
0012 2D92              *                  All Rights Reserved                         *
0013 2D92              *                  Apple Computer, Inc.                        *
0014 2D92              *                                                              *
0015 2D92              ****************************************************************
0016 2D92              *
0017 2D92              * 26-Sep-90	Dave Lyons
0018 2D92              *
0019 2D92              * Brought in macros from old nonstandard all.macros.
0020 2D92              *
0021 2D92              *
0022 2D92                       string asis 
0023 2D92                       blanks off 
0024 2D92
0025 2D92                       include 'all.macros' 
0026 2D92                       include ':QDEquates:qd.data.asm' 
0027 2D92
0028 2D92                       INCLUDE ':QDEquates:core.globals1' 
0029 2D92                       INCLUDE ':QDEquates:core.globals2' 
0030 2D92                       INCLUDE ':QDEquates:region.equs' 
0031 2D92                       INCLUDE ':QDEquates:rect.equs' 
0032 2D92                       INCLUDE ':QDEquates:slab.equs' 
0033 2D92
0034 2D92                       include '::sys.equs.asm' 
0035 2D92
0036 2D92              ; Some handy rectange equates
0037 2D92              o_V1     equ   0
0038 2D92              o_H1     equ   2
0039 2D92              o_V2     equ   4
0040 2D92              o_H2     equ   6
0041 2D92              ;-----------------------------------------------
0042 2D92              ;
0043 2D92              ;   Imported addresses
0044 2D92              ;
0045 2D92              ;-----------------------------------------------
0046 2D92
0047 2D92                       IMPORT BusyErr4 
0048 2D92                       IMPORT BusyErr8 
0049 2D92                       IMPORT DerefC 
0050 2D92                       IMPORT DrawRgn 
0051 2D92                       IMPORT FastSlabBIC 
0052 2D92                       IMPORT FastSlabCopy 
0053 2D92                       IMPORT FastSlabOR 
0054 2D92                       IMPORT FastSlabXOR 
0055 2D92                       IMPORT GetBoundsC 
0056 2D92                       IMPORT MinRectToY1 
0057 2D92                       IMPORT QDStart 
0058 2D92                       IMPORT RgnSave 
0059 2D92                       IMPORT SlabBIC 
0060 2D92                       IMPORT SlabCopy 
0061 2D92                       IMPORT SlabOR 
0062 2D92                       IMPORT SlabXOR 
0063 2D92                       IMPORT TestGPs 
0064 2D92                       IMPORT UnlockC 
0065 2D92
0066 2D92              ;-----------------------------------------------
0067 2D92              ;
0068 2D92              ;   Forward addresses and entries
0069 2D92              ;
0070 2D92              ;-----------------------------------------------
0071 2D92
0072 2D92                       ENTRY CallRect 
0073 2D92                       ENTRY CheckPenVis 
0074 2D92                       ENTRY FastSlabTable 
0075 2D92                       ENTRY FrRect 
0076 2D92                       ENTRY GetRect 
0077 2D92                       ENTRY GrabPenSize 
0078 2D92                       ENTRY JoinRect 
0079 2D92                       ENTRY LeftMaskTable 
0080 2D92                       ENTRY NextPatSlice 
0081 2D92                       ENTRY RightMaskTable 
0082 2D92                       ENTRY SetFirstDestRef 
0083 2D92                       ENTRY SetNextDestRef 
0084 2D92                       ENTRY SlabTable 
0085 2D92                       ENTRY XSetUp640 
0086 2D92                       ENTRY iDrawRect 
0087 2D92
0088 2D92
0089 2D92
0090 2D92              ;                COPY RECTS/SLAB.SETUP
0091 2D92              ****************************************************************
0092 2D92              *
0093 2D92              * SetSlabAdr
0094 2D92              *
0095 2D92              * This routine sets of the vector "ToSlab" in bank E0.  All
0096 2D92              * drawing routines use this vector to get to their slab routine.
0097 2D92              *
0098 2D92              * If the clipping is non-rectangular or the drawing mask is
0099 2D92              * not all $FFFF's, then we use the normal slabs.  Otherwise
0100 2D92              * we use the FAST SLABS.
0101 2D92              *
0102 2D92              * 2/28/89	Konstantin and Dave
0103 2D92              * Also, returned in carry whether a fast slab is being used, and
0104 2D92              * returned in <X> is the offset to the slab table. THIS SHOULD
0105 2D92              * NOT CHANGE
0106 2D92              ****************************************************************
0107 2D92              iSetSlabAdr PROC EXPORT 
0108 2D92
0109 2D92 A5 B6                 lda   FillMode
0110 2D94 29 7F 00              and   #$7F
0111 2D97 0A                    asl   a
0112 2D98 0A                    asl   a
0113 2D99 AA                    tax   
0114 2D9A
0115 2D9A A5 A4                 lda   NonRectRegions
0116 2D9C D0 17                 bne   GoSlow
0117 2D9E
0118 2D9E A0 6A 00              ldy   #o_PnMask                ;go fast if there is no mask
0119 2DA1 B7 24                 lda   [PortRef],y
0120 2DA3 A0 6C 00              ldy   #o_PnMask+2
0121 2DA6 37 24                 and   [PortRef],y
0122 2DA8 A0 6E 00              ldy   #o_PnMask+4
0123 2DAB 37 24                 and   [PortRef],y
0124 2DAD A0 70 00              ldy   #o_PnMask+6
0125 2DB0 37 24                 and   [PortRef],y
0126 2DB2 1A                    inc   a                        ;are they all $FFFF?
0127 2DB3 F0 12                 beq   GoFast
0128 2DB5              GoSlow                                  ; 
0129 2DB5
0130 2DB5
0131 2DB5 BF D9 2D FE           lda   >SlabTable,x
0132 2DB9 8F 00 1E E0           sta   >ToSlab
0133 2DBD BF DB 2D FE           lda   >SlabTable+2,x
0134 2DC1 8F 02 1E E0           sta   >ToSlab+2
0135 2DC5 38                    sec                            ;we must go slow
0136 2DC6 6B                    rtl   
0137 2DC7
0138 2DC7              GoFast    
0139 2DC7 BF E9 2D FE           lda   >FastSlabTable,x
0140 2DCB 8F 00 1E E0           sta   >ToSlab
0141 2DCF BF EB 2D FE           lda   >FastSlabTable+2,x
0142 2DD3 8F 02 1E E0           sta   >ToSlab+2
0143 2DD7 18                    clc                            ;signals that we can go fast
0144 2DD8 6B                    rtl   
0145 2DD9
0146 2DD9
0147 2DD9
0148 2DD9
0149 2DD9                       ENDP 
0150 2DD9
0151 2DD9
0152 2DD9
0153 2DD9              ****************************************************************
0154 2DD9              *
0155 2DD9              * SlabTable
0156 2DD9              *
0157 2DD9              ****************************************************************
0158 2DD9              SlabTable PROC EXPORT 
0159 2DD9
0160 2DD9 5C D0 24 FE           jml   SlabCopy
0161 2DDD 5C 68 25 FE           jml   SlabOR
0162 2DE1 5C F6 25 FE           jml   SlabXOR
0163 2DE5 5C 84 26 FE           jml   SlabBIC
0164 2DE9
0165 2DE9                       ENDP 
0166 2DE9
0167 2DE9              ****************************************************************
0168 2DE9              *
0169 2DE9              * FastSlabTable
0170 2DE9              *
0171 2DE9              ****************************************************************
0172 2DE9              FastSlabTable PROC EXPORT 
0173 2DE9
0174 2DE9 5C 26 2A FE           jml   FastSlabCopy
0175 2DED 5C 90 2C FE           jml   FastSlabOR
0176 2DF1 5C 21 27 FE           jml   FastSlabXOR
0177 2DF5 5C 09 2D FE           jml   FastSlabBIC
0178 2DF9
0179 2DF9                       ENDP 
0180 2DF9              ****************************************************************
0181 2DF9              *
0182 2DF9              * PreDRAW
0183 2DF9              *
0184 2DF9              * Puts the pen pattern into TheFillPat and the pen mode into
0185 2DF9              * FillMode
0186 2DF9              *
0187 2DF9              ****************************************************************
0188 2DF9              iPreDraw PROC EXPORT 
0189 2DF9
0190 2DF9 A2 00 02              ldx   #512
0191 2DFC B5 EC                 lda   <DirtyDPFlags,x
0192 2DFE 29 20 A4              and   #PreDrawOK               ; Fixed to and by Mensch 4/24/89
0193 2E01 C9 20 A4              cmp   #PreDrawOK
0194 2E04 F0 0C                 beq   @PreDrawDone
0195 2E06
0196 2E06 22 3C 1E E0           jsl   PortLoc2ZP               ; get the port info down to zp
0197 2E0A 22 44 1E E0           jsl   GetPenPReady             ; get the pattern down to zp
0198 2E0E 22 58 1E E0           jsl   GetMaskReady
0199 2E12              @PreDrawDone  
0200 2E12 A0 48 00              ldy   #O_PnMode                ; get the mode down to zp
0201 2E15 B7 24                 lda   [PortRef],y
0202 2E17 85 B6                 sta   FillMode
0203 2E19
0204 2E19 6B                    rtl   
0205 2E1A
0206 2E1A                       ENDP 
0207 2E1A
0208 2E1A              ****************************************************************
0209 2E1A              *
0210 2E1A              * XSetUp
0211 2E1A              *
0212 2E1A              * suck up 4 cycles...
0213 2E1A              ****************************************************************
0214 2E1A              iXSetUp  PROC EXPORT 
0215 2E1A
0216 2E1A 24 07                 bit   MasterSCB-1
0217 2E1C 30 33                 bmi   XSetUp640
0218 2E1E
0219 2E1E                       ENDP 
0220 2E1E
0221 2E1E              ****************************************************************
0222 2E1E              *
0223 2E1E              * XSetUp320
0224 2E1E              *
0225 2E1E              ****************************************************************
0226 2E1E              XSetUp320 PROC EXPORT 
0227 2E1E
0228 2E1E
0229 2E1E A5 A8                 lda   X1                       ; convert local coordinates to
0230 2E20 38                    sec                            ; memory coordinates
0231 2E21 E5 16                 sbc   BoundsRect+2             ; start with left point
0232 2E23
0233 2E23 A8                    tay                            ; save copy in y
0234 2E24 29 03 00              and   #3                       ; mask off all but low 2 bits
0235 2E27 0A                    asl   a                        ; quadruple result and put in
0236 2E28 0A                    asl   a
0237 2E29 AA                    tax                            ; x
0238 2E2A
0239 2E2A 98                    tya                            ; retrieve y and half it so it refers
0240 2E2B 4A                    lsr   a                        ; to a byte (not a pixel)
0241 2E2C 29 FE FF              and   #$FFFF-1                 ; make it even
0242 2E2F 85 C4                 sta   StartWord
0243 2E31
0244 2E31 BF 84 2E FE           lda   >LeftMaskTable,x
0245 2E35 85 A0                 sta   LeftMask                 ; across words don't work for pixels
0246 2E37
0247 2E37 A5 AC                 lda   X2                       ; convert local coordinates to
0248 2E39 18                    clc   
0249 2E3A E5 16                 sbc   BoundsRect+2
0250 2E3C              ; dec a See 640mode for comment	; one less so don't overwrite limit
0251 2E3C
0252 2E3C A8                    tay                            ; save copy in y
0253 2E3D 29 03 00              and   #3                       ; mask off all but low 2 bits
0254 2E40 0A                    asl   a                        ; quadruple result and put in
0255 2E41 0A                    asl   a
0256 2E42 AA                    tax                            ; x
0257 2E43
0258 2E43
0259 2E43 98                    tya                            ; retrieve y and half it so it refers
0260 2E44 4A                    lsr   a                        ; to a byte (not a pixel)
0261 2E45 29 FE FF              and   #$FFFF-1                 ; make it even
0262 2E48 85 C6                 sta   FinishWord
0263 2E4A
0264 2E4A BF 96 2E FE           lda   >RightMaskTable+2,x
0265 2E4E 85 A2                 sta   RightMask
0266 2E50
0267 2E50 6B                    rtl   
0268 2E51
0269 2E51                       ENDP 
0270 2E51
0271 2E51
0272 2E51              ****************************************************************
0273 2E51              *
0274 2E51              * XSetUp640
0275 2E51              *
0276 2E51              ****************************************************************
0277 2E51              XSetUp640 PROC EXPORT 
0278 2E51
0279 2E51
0280 2E51              * Now we figure out where in an even word, the first and last
0281 2E51              * pixels lie.  Then we create a masks to protect the pixels
0282 2E51              * that are not to be touched.
0283 2E51
0284 2E51 A5 A8                 lda   X1                       ; convert local coordinates to
0285 2E53 38                    sec                            ; memory coordinates
0286 2E54 E5 16                 sbc   BoundsRect+2             ; start with left point
0287 2E56
0288 2E56 A8                    tay                            ; save a copy in y
0289 2E57 29 07 00              and   #7                       ; mask off all but low 3 bits
0290 2E5A 0A                    asl   a                        ; double this and put in
0291 2E5B AA                    tax                            ; x
0292 2E5C
0293 2E5C 98                    tya                            ; retrieve y
0294 2E5D 4A                    lsr   a                        ; divide by 4 so refers to addr
0295 2E5E 4A                    lsr   a                        ; of a byte
0296 2E5F 29 FE FF              and   #$FFFF-1                 ; make it even
0297 2E62 85 C4                 sta   StartWord
0298 2E64
0299 2E64 BF 84 2E FE           lda   >LeftMaskTable,x
0300 2E68 85 A0                 sta   LeftMask
0301 2E6A
0302 2E6A A5 AC                 lda   X2                       ; convert local coordinates to
0303 2E6C 18                    clc                            ; than coordinate
0304 2E6D E5 16                 sbc   BoundsRect+2
0305 2E6F              ; was this, but change thar sec above and presto!
0306 2E6F              ; dec a  ; last pixel touched is one less
0307 2E6F
0308 2E6F A8                    tay                            ; save it in y
0309 2E70 29 07 00              and   #7                       ; mask off all but low 3 bits
0310 2E73 0A                    asl   a                        ; double this
0311 2E74 AA                    tax                            ; put in x
0312 2E75 98                    tya                            ; retrieve y
0313 2E76 4A                    lsr   a                        ; divide by 4 so points to byte
0314 2E77 4A                    lsr   a
0315 2E78 29 FE FF              and   #$FFFF-1                 ; make even
0316 2E7B 85 C6                 sta   FinishWord
0317 2E7D
0318 2E7D BF 94 2E FE           lda   >RightMaskTable,x
0319 2E81 85 A2                 sta   RightMask
0320 2E83
0321 2E83 6B                    rtl   
0322 2E84
0323 2E84                       ENDP 
0324 2E84
0325 2E84
0326 2E84              ****************************************************************
0327 2E84              *
0328 2E84              * LeftMaskTable
0329 2E84              *
0330 2E84              * This table is not what you think.  Since the words in
0331 2E84              * the scan line have the pixels in byte order (not word order)
0332 2E84              * the mask must be reversed.  The b declaration does that
0333 2E84              * because it reads information a byte at a time in the order
0334 2E84              * it finds it.  So the bits on the left appear in the low
0335 2E84              * byte of the table entry while the bits on the right
0336 2E84              * appear in the high byte of the table entry.
0337 2E84              *
0338 2E84              ****************************************************************
0339 2E84              LeftMaskTable PROC EXPORT 
0340 2E84
0341 2E84 FF FF                 DC B:%11111111,%11111111
0342 2E86 3F FF                 DC B:%00111111,%11111111
0343 2E88 0F FF                 DC B:%00001111,%11111111
0344 2E8A 03 FF                 DC B:%00000011,%11111111
0345 2E8C 00 FF                 DC B:%00000000,%11111111
0346 2E8E 00 3F                 DC B:%00000000,%00111111
0347 2E90 00 0F                 DC B:%00000000,%00001111
0348 2E92 00 03                 DC B:%00000000,%00000011
0349 2E94
0350 2E94                       ENDP 
0351 2E94
0352 2E94
0353 2E94              ****************************************************************
0354 2E94              *
0355 2E94              * RightMaskTable
0356 2E94              *
0357 2E94              ****************************************************************
0358 2E94              RightMaskTable PROC EXPORT 
0359 2E94
0360 2E94 C0 00                 DC B:%11000000,%00000000
0361 2E96 F0 00                 DC B:%11110000,%00000000
0362 2E98 FC 00                 DC B:%11111100,%00000000
0363 2E9A FF 00                 DC B:%11111111,%00000000
0364 2E9C FF C0                 DC B:%11111111,%11000000
0365 2E9E FF F0                 DC B:%11111111,%11110000
0366 2EA0 FF FC                 DC B:%11111111,%11111100
0367 2EA2 FF FF                 DC B:%11111111,%11111111
0368 2EA4
0369 2EA4                       ENDP 
0370 2EA4              ;                copy RECTS/common
0371 2EA4              ****************************************************************
0372 2EA4              *
0373 2EA4              * Common routine to set up everything needed when drawing
0374 2EA4              * slabs.
0375 2EA4              *
0376 2EA4              * For this to work we use one new equate called WhosCalling.
0377 2EA4              * This is set to DrawNoun-1.  This lets us make the following
0378 2EA4              * assumptions
0379 2EA4              *
0380 2EA4              *       Noun               Bits in WhosCalling
0381 2EA4              *
0382 2EA4              *       RectNoun = $30     bit 15 clear   bit 14 clear
0383 2EA4              *       RgnNoun = $80      bit 15 set     bit 14 clear
0384 2EA4              *       RRectNoun = $40    bit 15 clear   bit 14 set
0385 2EA4              *       OvalNoun = $50     bit 15 clear   bit 14 set
0386 2EA4              *       ArcNoun = $60      bit 15 clear   bit 14 set
0387 2EA4              *
0388 2EA4              * In this way we can to a BIT WhosCalling an know exactly
0389 2EA4              * which of the three possible drawing routines will be used.
0390 2EA4              *
0391 2EA4              * I wish I could claim credit for discovering this.  Actually, Art
0392 2EA4              * looked at the nouns and made this observation.  Good work	Art.
0393 2EA4              *
0394 2EA4              ****************************************************************
0395 2EA4              CommonSlabSetup PROC EXPORT 
0396 2EA4
0397 2EA4
0398 2EA4
0399 2EA4 20 17 34              jsr   CheckPenVis              ; if the pen is not visible there is
0400 2EA7              *			; no return
0401 2EA7
0402 2EA7 22 3C 1E E0           jsl   PortLoc2ZP               ; all routines need this done.
0403 2EAB                       Export CommonSlabSetup2 
0404 2EAB              CommonSlabSetup2  
0405 2EAB 22 A0 1E E0           jsl   SetUpPortRegions         ; all routines need this done.
0406 2EAF
0407 2EAF 24 39                 bit   WhosCalling
0408 2EB1 10 0C                 bpl   NotRgn
0409 2EB3
0410 2EB3 20 BF 5A              jsr   DerefC                   ; first deref the handle in RgnHandleC
0411 2EB6 20 45 58              jsr   GetBoundsC               ; Region calls bounding box of RGN C
0412 2EB9              *			; moved to min rect.
0413 2EB9 22 94 1E E0           jsl   MakeMinRect              ; so it does not use BMinRect
0414 2EBD 80 04                 bra   MinRectDone
0415 2EBF
0416 2EBF 22 90 1E E0  NotRgn   jsl   BMakeMinRect
0417 2EC3
0418 2EC3 B0 20        MinRectDone bcs   NeverMind
0419 2EC5
0420 2EC5 24 39                 bit   WhosCalling
0421 2EC7 70 03                 bvs   ItsConics
0422 2EC9
0423 2EC9 20 88 4D              jsr   MinRectToY1
0424 2ECC
0425 2ECC              ItsConics                               ; 
0426 2ECC
0427 2ECC
0428 2ECC              ;-----------------------------------------------------
0429 2ECC              ;
0430 2ECC              ; Do right thing to pattern given what we are doing.
0431 2ECC              ;
0432 2ECC A5 38                 lda   DrawVerb
0433 2ECE 0A                    asl   a
0434 2ECF AA                    tax   
0435 2ED0 FC F5 2E              jsr   (FixPatTable,x)
0436 2ED3 85 B6                 sta   FillMode
0437 2ED5
0438 2ED5              PatIsReady                              ; 
0439 2ED5 22 58 1E E0           jsl   GetMaskReady
0440 2ED9
0441 2ED9 22 98 1E E0           jsl   ShieldCursor
0442 2EDD
0443 2EDD 22 48 2F FE           jsl   DoTheDrawing
0444 2EE1
0445 2EE1 22 9C 1E E0           jsl   UnshieldCursor
0446 2EE5
0447 2EE5
0448 2EE5
0449 2EE5 22 A8 1E E0  NeverMind jsl   FreePortRegions
0450 2EE9
0451 2EE9 24 39                 bit   <WhosCalling
0452 2EEB 10 03                 bpl   NotRgn2
0453 2EED 20 D5 5A              jsr   UnlockC
0454 2EF0
0455 2EF0              NotRgn2                                 ; 
0456 2EF0
0457 2EF0
0458 2EF0 A9 00 00              lda   #0
0459 2EF3 18                    clc   
0460 2EF4 6B                    rtl   
0461 2EF5
0462 2EF5 FF 2E        FixPatTable DC W:ForPaint               ; this will never be used
0463 2EF7 FF 2E                 DC W:ForPaint
0464 2EF9 09 2F                 DC W:ForErase
0465 2EFB 11 2F                 DC W:ForInvert
0466 2EFD 3A 2F                 DC W:ForFill
0467 2EFF
0468 2EFF              ForPaint                                ; 
0469 2EFF 22 44 1E E0           jsl   GetPenPReady
0470 2F03 A0 48 00              ldy   #o_PnMode
0471 2F06 B7 24                 lda   [PortRef],y
0472 2F08 60                    rts   
0473 2F09
0474 2F09
0475 2F09              ForErase                                ; 
0476 2F09 22 48 1E E0           jsl   GetBackPReady
0477 2F0D A9 00 00              lda   #modecopy
0478 2F10 60                    rts   
0479 2F11
0480 2F11              ForInvert                               ; 
0481 2F11 A2 00 02              ldx   #512                     ; test to see if we can use the dirty flag stuff
0482 2F14 B5 EC                 lda   <DirtyDPFlags,x
0483 2F16 10 0F                 bpl   @GoSlow
0484 2F18 A8                    tay                            ; save this value for a sec...
0485 2F19 29 00 10              and   #InvPatternOK            ; see if its ok to draw...
0486 2F1C D0 18                 bne   @PatternDone
0487 2F1E 98                    tya                            ; get the flags back
0488 2F1F 29 FF 87              and   #AllPatsBad
0489 2F22 09 00 18              ora   #InvPatternOK+SolidPatOK
0490 2F25 95 EC                 sta   <DirtyDPFlags,x
0491 2F27              @GoSlow   
0492 2F27 A9 FF FF              lda   #$FFFF
0493 2F2A A2 00 01              ldx   #256
0494 2F2D 95 0E        @PatLoop sta   TheFillPat,x
0495 2F2F E8                    inx   
0496 2F30 E8                    inx   
0497 2F31 E0 20 01              cpx   #PatSize+256
0498 2F34 90 F7                 bcc   @PatLoop
0499 2F36              @PatternDone  
0500 2F36 A9 02 00              lda   #ModeXOR
0501 2F39 60                    rts   
0502 2F3A
0503 2F3A
0504 2F3A              ForFill                                 ; 
0505 2F3A A5 16                 lda   BoundsRect+2
0506 2F3C 29 07 00              and   #7
0507 2F3F A8                    tay   
0508 2F40 22 54 1E E0           jsl   RotatePat
0509 2F44 A9 00 00              lda   #ModeCopy
0510 2F47 60                    rts   
0511 2F48
0512 2F48
0513 2F48
0514 2F48              DoTheDrawing                            ; 
0515 2F48
0516 2F48 24 39                 bit   WhosCalling
0517 2F4A 30 06                 bmi   ItsRgn
0518 2F4C 70 08                 bvs   ItsConics2
0519 2F4E 5C 78 1E E0           jml   DrawRect
0520 2F52 5C 1A 58 FE  ItsRgn   jml   DrawRgn
0521 2F56 5C C4 1F E0  ItsConics2 jml   DrawConic
0522 2F5A
0523 2F5A
0524 2F5A                       ENDP 
0525 2F5A              ;                COPY RECTS/RECTS
0526 2F5A              ****************************************************************
0527 2F5A              *
0528 2F5A              * FrameRect  (r : rect)
0529 2F5A              *
0530 2F5A              * Modifications
0531 2F5A              *
0532 2F5A              *    April 7, 1986	   Now returns error from CallRect.
0533 2F5A              *
0534 2F5A              ****************************************************************
0535 2F5A              FrameRect PROC EXPORT 
0536 2F5A
0537 2F5A A2 00 00              ldx   #FrameVerb
0538 2F5D 80 0D                 bra   JoinRect
0539 2F5F
0540 2F5F                       ENDP 
0541 2F5F
0542 2F5F              ****************************************************************
0543 2F5F              *
0544 2F5F              * PaintRect    (r : rect)
0545 2F5F              *
0546 2F5F              * Modifications
0547 2F5F              *
0548 2F5F              *    April 7, 1986    Now returns error from CallRect.
0549 2F5F              *
0550 2F5F              ****************************************************************
0551 2F5F              PaintRect PROC EXPORT 
0552 2F5F
0553 2F5F A2 01 00              ldx   #PaintVerb
0554 2F62 80 08                 bra   JoinRect
0555 2F64
0556 2F64                       ENDP 
0557 2F64
0558 2F64              ****************************************************************
0559 2F64              *
0560 2F64              * EraseRect    (r : rect)
0561 2F64              *
0562 2F64              * Modifications
0563 2F64              *
0564 2F64              *    April 7, 1986    Now returns error from CallRect.
0565 2F64              *
0566 2F64              ****************************************************************
0567 2F64              EraseRect PROC EXPORT 
0568 2F64
0569 2F64 A2 02 00              ldx   #EraseVerb
0570 2F67 80 03                 bra   JoinRect
0571 2F69
0572 2F69                       ENDP 
0573 2F69
0574 2F69              ****************************************************************
0575 2F69              *
0576 2F69              * InvertRect   (r : rect)
0577 2F69              *
0578 2F69              * Modifications
0579 2F69              *
0580 2F69              *    April 7, 1986    Now returns error from CallRect.
0581 2F69              *                 
0582 2F69              ****************************************************************
0583 2F69              InvertRect PROC EXPORT 
0584 2F69
0585 2F69 A2 03 00              ldx   #InvertVerb
0586 2F6C              ; let this one fall into join rect
0587 2F6C
0588 2F6C                       ENDP 
0589 2F6C
0590 2F6C              ****************************************************************
0591 2F6C              *
0592 2F6C              * JoinRect
0593 2F6C              *
0594 2F6C              * JoinRect is a common routine called by frame, paint,invert
0595 2F6C              * and erase rect.  The draw verb is passed in X
0596 2F6C              *
0597 2F6C              * Modifications
0598 2F6C              *
0599 2F6C              *    Apr 14, 1989    QDStart is now inline and the jmp BusyErr8
0600 2F6C              *                    is long so it can work in the patch.
0601 2F6C              ****************************************************************
0602 2F6C              JoinRect PROC EXPORT 
0603 2F6C
0604 2F6C 0B                    phd   
0605 2F6D 5B                    tcd   
0606 2F6E AF FF 00 E1           lda   >BusyFlag
0607 2F72 1A                    inc   a
0608 2F73 8F FF 00 E1           sta   >BusyFlag
0609 2F77
0610 2F77              ;
0611 2F77              ; DEBUG HERE
0612 2F77              ;
0613 2F77              ;	lda	>$E0C025
0614 2F77              ;	and	#$0004
0615 2F77              ;	beq	@NoDebug
0616 2F77              ;	brk	00
0617 2F77              ;@NoDebug
0618 2F77 86 38                 stx   DrawVerb                 ; save draw verb on zp
0619 2F79 20 AD 2F              jsr   GetRect                  ; get the rect to zp
0620 2F7C A6 38                 ldx   DrawVerb                 ; get the draw verb back
0621 2F7E 22 C2 2F FE           jsl   CallRect                 ; call rect
0622 2F82 AA                    tax                            ; return any error
0623 2F83 5C 1C FC FE           jml   BusyErr4
0624 2F87
0625 2F87                       ENDP 
0626 2F87
0627 2F87              ****************************************************************
0628 2F87              *
0629 2F87              * FillRect     (r : rect; p : pattern)
0630 2F87              *
0631 2F87              * Modifications
0632 2F87              *
0633 2F87              *    April 7, 1986    Now returns error from CallRect.
0634 2F87              *
0635 2F87              *    Feb 25, 1987     Now calls QDStart at beginning!
0636 2F87              *
0637 2F87              *    Apr 14, 1989     QDStart is now inline and the jmp BusyErr8
0638 2F87              *                     is long so it can work in the patch.
0639 2F87              *
0640 2F87              ****************************************************************
0641 2F87              FillRect PROC EXPORT 
0642 2F87
0643 2F87              OrigDirect equ   1
0644 2F87              RTL1     equ   OrigDirect+2
0645 2F87              RTL2     equ   RTL1+3
0646 2F87              PPtr     equ   RTL2+3
0647 2F87              RPtr     equ   PPtr+4
0648 2F87
0649 2F87 0B                    phd   
0650 2F88 5B                    tcd   
0651 2F89 AF FF 00 E1           lda   >BusyFlag
0652 2F8D 1A                    inc   a
0653 2F8E 8F FF 00 E1           sta   >BusyFlag
0654 2F92
0655 2F92 22 40 1E E0           jsl   UserPat2ZP
0656 2F96 A3 0D                 lda   RPtr,s
0657 2F98 83 09                 sta   PPtr,s
0658 2F9A A3 0F                 lda   RPtr+2,s
0659 2F9C 83 0B                 sta   PPtr+2,s
0660 2F9E 20 AD 2F              jsr   GetRect
0661 2FA1
0662 2FA1 A2 04 00              ldx   #FillVerb
0663 2FA4 22 C2 2F FE           jsl   CallRect
0664 2FA8 AA                    tax   
0665 2FA9 5C 48 FC FE           jml   BusyErr8
0666 2FAD
0667 2FAD
0668 2FAD                       ENDP 
0669 2FAD
0670 2FAD
0671 2FAD              ****************************************************************
0672 2FAD              *
0673 2FAD              * GetRect
0674 2FAD              *
0675 2FAD              * Internal routine to move the rectangle pointed to by
0676 2FAD              * the pointer on the stack to Y1 etc.
0677 2FAD              *
0678 2FAD              * This routine trashes temp (four bytes on zp) and
0679 2FAD              * all registers.
0680 2FAD              *
0681 2FAD              ****************************************************************
0682 2FAD              GetRect  PROC EXPORT 
0683 2FAD
0684 2FAD              RTSAdr   equ   1
0685 2FAD              OrigDirect equ   RTSAdr+2
0686 2FAD              RTL1     equ   OrigDirect+2
0687 2FAD              RTL2     equ   RTL1+3
0688 2FAD              RPtr     equ   RTL2+3
0689 2FAD
0690 2FAD A3 0B                 lda   RPtr,s
0691 2FAF 85 2A                 sta   Temp
0692 2FB1 A3 0C                 lda   RPtr+1,s
0693 2FB3 85 2B                 sta   Temp+1
0694 2FB5
0695 2FB5 A0 06 00              ldy   #6
0696 2FB8 BB           PLoop    tyx   
0697 2FB9 B7 2A                 lda   [Temp],y
0698 2FBB 95 A6                 sta   Y1,x
0699 2FBD 88                    dey   
0700 2FBE 88                    dey   
0701 2FBF 10 F7                 bpl   PLoop
0702 2FC1 60                    rts   
0703 2FC2
0704 2FC2                       ENDP 
0705 2FC2
0706 2FC2              ****************************************************************
0707 2FC2              *
0708 2FC2              * CallRect
0709 2FC2              *
0710 2FC2              * This routine is jumped (or branched) to by the
0711 2FC2              * entry points after the graf verb is loaded into the
0712 2FC2              * x register.
0713 2FC2              *
0714 2FC2              * Zero page is already switched in by the time it gets here.
0715 2FC2              *
0716 2FC2              ****************************************************************
0717 2FC2              CallRect PROC EXPORT 
0718 2FC2              ; The following code is pretty handy when debugging rects, tryit, you'll like it...
0719 2FC2              ;@wait	lda	>$E0C000
0720 2FC2              ;	bpl	@Wait
0721 2FC2              ;	sta	>$E0C010
0722 2FC2              ;	and	#$7F
0723 2FC2              ;	cmp	#$1B
0724 2FC2              ;	bne	@NoDebug
0725 2FC2              ;	brk	00
0726 2FC2              @NoDebug  
0727 2FC2
0728 2FC2 86 38                 stx   DrawVerb
0729 2FC4
0730 2FC4 A9 30 00              lda   #RectNoun                ;
0731 2FC7 85 3A                 sta   DrawNoun                 ; put on zp for later too!!!!
0732 2FC9
0733 2FC9 A2 00 02              ldx   #512                     ; test the DirtyDPFlags for picts and pen...
0734 2FCC B5 EC                 lda   <DirtyDPFlags,x
0735 2FCE 29 3F 80              and   #TestDrawState
0736 2FD1 C9 3F 80              cmp   #TestDrawState
0737 2FD4 F0 16                 beq   DoFasterSetup            ; if this is zero, then pen vis/no pictures etc...
0738 2FD6
0739 2FD6 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0740 2FD9 B0 04                 bcs   UseLocal
0741 2FDB
0742 2FDB 5C 0C 1E E0           jml   StdRect
0743 2FDF
0744 2FDF
0745 2FDF 8B           UseLocal phb                            ; put extra byte on stack
0746 2FE0 A0 08 00              ldy   #o_stdrect               ; get adr of new rect routine
0747 2FE3 B7 2A                 lda   [temp],y                 ; put on stack
0748 2FE5 48                    pha   
0749 2FE6 C8                    iny                            ; get bytes 2 and 3
0750 2FE7 B7 2A                 lda   [temp],y
0751 2FE9 83 02                 sta   2,s                      ; store middle byte twice
0752 2FEB 6B                    rtl                            ; call it
0753 2FEC
0754 2FEC              DoFasterSetup  
0755 2FEC A5 38                 lda   DrawVerb                 ; put verb in a
0756 2FEE D0 03                 bne   NotFrame
0757 2FF0 4C 1D 30              jmp   FrRect
0758 2FF3              NotFrame  
0759 2FF3 4C AB 2E              jmp   CommonSlabSetup2
0760 2FF6
0761 2FF6                       ENDP 
0762 2FF6
0763 2FF6
0764 2FF6              ****************************************************************
0765 2FF6              *
0766 2FF6              * StdRect
0767 2FF6              *
0768 2FF6              * Common rectangle routine that is central point for
0769 2FF6              * all rectangle drawing routines.
0770 2FF6              *
0771 2FF6              * When control gets here, all inputs are on zero page.
0772 2FF6              *       TheRect is kept in Y1 thru X2
0773 2FF6              *       ThePat (if any) is in TheFillPat
0774 2FF6              *       WhatToDo is in DrawVerb
0775 2FF6              *
0776 2FF6              * Modifications
0777 2FF6              *
0778 2FF6              *   April 7, 1986   Now checks error returns from PutPicStuff
0779 2FF6              *                   and PutRect.
0780 2FF6              *
0781 2FF6              ****************************************************************
0782 2FF6              iStdRect PROC EXPORT 
0783 2FF6
0784 2FF6 A9 30 00              lda   #RectNoun                ;
0785 2FF9 85 3A                 sta   DrawNoun                 ; put on zp for later too!!!!
0786 2FFB
0787 2FFB 22 F8 1E E0           jsl   PutPictStuff             ; inputs on zp and in a-reg
0788 2FFF 90 01                 bcc   NoPicErr
0789 3001
0790 3001 6B                    rtl                            ; return the error
0791 3002
0792 3002
0793 3002              NoPicErr                                ; 
0794 3002 A5 38                 lda   DrawVerb                 ; put verb in a
0795 3004 D0 0C                 bne   NotFrame
0796 3006
0797 3006 20 45 6B              jsr   RgnSave                  ; does this contribute to region def
0798 3009 90 12                 bcc   FrRect                   ; no, so frame it
0799 300B 22 88 1F E0           jsl   PutRect                  ; yes, so call putrect
0800 300F 90 0C                 bcc   FrRect                   ; no error so frame it.
0801 3011
0802 3011 6B                    rtl                            ; return the error
0803 3012
0804 3012              NotFrame                                ; 
0805 3012
0806 3012
0807 3012 4C A4 2E              jmp   CommonSlabSetup
0808 3015
0809 3015
0810 3015
0811 3015                       ENDP 
0812 3015
0813 3015
0814 3015              ****************************************************************
0815 3015              *
0816 3015              * PRect, FRect, IRect, ERect
0817 3015              *
0818 3015              ****************************************************************
0819 3015              PRect    PROC EXPORT 
0820 3015                       ENDP 
0821 3015              FRect    PROC EXPORT 
0822 3015                       ENDP 
0823 3015              IRect    PROC EXPORT 
0824 3015                       ENDP 
0825 3015              ERect    PROC EXPORT 
0826 3015
0827 3015 A9 30 00              lda   #RectNoun
0828 3018 85 3A                 sta   DrawNoun
0829 301A 4C A4 2E              jmp   CommonSlabSetup
0830 301D
0831 301D
0832 301D                       ENDP 
0833 301D
0834 301D
0835 301D              ****************************************************************
0836 301D              *
0837 301D              * FrRect
0838 301D              *
0839 301D              * Modifications
0840 301D              *
0841 301D              *     April 7, 1986   Now returns "No Error"
0842 301D              *
0843 301D              ****************************************************************
0844 301D              FrRect   PROC EXPORT 
0845 301D
0846 301D 20 2F 34              jsr   GrabPenSize              ; don't come back unless visible
0847 3020 20 17 34              jsr   CheckPenVis              ; don't come back unless visible
0848 3023
0849 3023              ;-------------------------------------------------
0850 3023              ;
0851 3023              ; Put copy of rect in rect2
0852 3023              ;
0853 3023 A5 A6                 lda   y1
0854 3025 85 AE                 sta   Rect2
0855 3027 A5 A8                 lda   Y1+2
0856 3029 85 B0                 sta   Rect2+2
0857 302B A5 AA                 lda   Y1+4
0858 302D 85 B2                 sta   Rect2+4
0859 302F A5 AC                 lda   Y1+6
0860 3031 85 B4                 sta   Rect2+6
0861 3033              ; was
0862 3033              ;	ldx	#6
0863 3033              ;Loop	lda	Y1,x
0864 3033              ;	sta	Rect2,x
0865 3033              ;	dex
0866 3033              ;	dex
0867 3033              ;	bpl	Loop
0868 3033
0869 3033              ;-------------------------------------------------
0870 3033              ;
0871 3033              ; Check to see if this is a valid rectangle
0872 3033
0873 3033
0874 3033 22 6C 1E E0           jsl   PreDraw                  ; move stuff to zp
0875 3037 22 A0 1E E0           jsl   SetUpPortRegions
0876 303B
0877 303B 22 90 1E E0           jsl   BMakeMinRect
0878 303F 90 05                 bcc   ValidRect
0879 3041
0880 3041 22 A8 1E E0           jsl   FreePortRegions
0881 3045 6B                    rtl   
0882 3046
0883 3046 22 98 1E E0  ValidRect jsl   ShieldCursor
0884 304A
0885 304A              ;-------------------------------------------------
0886 304A              ;
0887 304A              ; See if the pen size is larger than rectangle
0888 304A              ;
0889 304A A2 02 00              ldx   #2
0890 304D B5 B2        CheckLoop lda   Rect2+4,x
0891 304F 38                    sec   
0892 3050 F5 AE                 sbc   Rect2,x
0893 3052 4A                    lsr   a
0894 3053 D5 B8                 cmp   LocalPnSize,x
0895 3055 90 06                 bcc   PenTooBig
0896 3057 CA                    dex   
0897 3058 CA                    dex   
0898 3059 10 F2                 bpl   CheckLoop
0899 305B 80 06                 bra   PenOkay
0900 305D
0901 305D 22 74 1E E0  PenTooBig jsl   DrawRectB
0902 3061 80 56                 bra   FinishIt
0903 3063
0904 3063
0905 3063              ;-----------------------------------------------
0906 3063              ;
0907 3063              ; We draw four rectangles in such a way that 
0908 3063              ; no pixel is drawn more than once
0909 3063              ;
0910 3063 A5 A6        PenOkay  lda   Y1                       ; first the top of the rect
0911 3065 18                    clc   
0912 3066 65 B8                 adc   LocalPnSize
0913 3068 85 AA                 sta   Y2
0914 306A 22 74 1E E0           jsl   DrawRectB
0915 306E              ;
0916 306E A5 B4                 lda   Rect2+o_H2
0917 3070 85 AC                 sta   x2
0918 3072 38                    sec   
0919 3073 E5 BA                 sbc   LocalPnSize+2
0920 3075 85 A8                 sta   x1
0921 3077
0922 3077 A5 B2                 lda   Rect2+o_V2
0923 3079 85 AA                 sta   Y2
0924 307B
0925 307B A5 AE                 lda   Rect2+o_V1
0926 307D 18                    clc   
0927 307E 65 B8                 adc   LocalPnSize
0928 3080 85 A6                 sta   Y1
0929 3082 22 74 1E E0           jsl   DrawRectB
0930 3086              ;
0931 3086 A5 B4                 lda   Rect2+o_H2
0932 3088 38                    sec   
0933 3089 E5 BA                 sbc   LocalPnSize+2
0934 308B 85 AC                 sta   X2
0935 308D
0936 308D A5 B2                 lda   Rect2+o_V2
0937 308F 85 AA                 sta   Y2
0938 3091 38                    sec   
0939 3092 E5 B8                 sbc   LocalPnSize
0940 3094 85 A6                 sta   Y1
0941 3096
0942 3096 A5 B0                 lda   Rect2+o_H1
0943 3098 85 A8                 sta   X1
0944 309A
0945 309A 22 74 1E E0           jsl   DrawRectB
0946 309E              ;
0947 309E
0948 309E A5 B2                 lda   Rect2+o_V2
0949 30A0 38                    sec   
0950 30A1 E5 B8                 sbc   LocalPnSize
0951 30A3 85 AA                 sta   Y2
0952 30A5
0953 30A5 A5 B0                 lda   Rect2+o_H1
0954 30A7 85 A8                 sta   X1
0955 30A9 18                    clc   
0956 30AA 65 BA                 adc   LocalPnSize+2
0957 30AC 85 AC                 sta   X2
0958 30AE
0959 30AE A5 AE                 lda   Rect2+o_V1
0960 30B0 18                    clc                            ; edges since they are already
0961 30B1 65 B8                 adc   LocalPnSize              ; done
0962 30B3 85 A6                 sta   Y1
0963 30B5 22 74 1E E0           jsl   DrawRectB
0964 30B9
0965 30B9 22 9C 1E E0  FinishIt jsl   UnshieldCursor
0966 30BD 22 A8 1E E0           jsl   FreePortRegions
0967 30C1 A9 00 00              lda   #0                       ; return no error
0968 30C4 18                    clc   
0969 30C5 6B                    rtl   
0970 30C6
0971 30C6
0972 30C6
0973 30C6                       ENDP 
0974 30C6
0975 30C6
0976 30C6
0977 30C6
0978 30C6              ****************************************************************
0979 30C6              *
0980 30C6              * DrawRect
0981 30C6              *
0982 30C6              * Draws the specified rectangle using the pattern kept in
0983 30C6              * TheFillPat, using the mode kept in FillMode
0984 30C6              *
0985 30C6              * 2/22/89      Konstantin & Dave
0986 30C6              *              Changed SetSlabAdr so that the carry is clear
0987 30C6              * when the clip region is rectangular and the draw mask is all $FFFF.
0988 30C6              *
0989 30C6              * 2/24/89      Konstantin
0990 30C6              *              If the regions are rectangular, we don't need to call
0991 30C6              *              Init2Regions.
0992 30C6              *
0993 30C6              * 3/3/89       Mensch
0994 30C6              *              Add faster "thin rect" drawing. This should speed
0995 30C6              *              up framerect a bunch!
0996 30C6              *
0997 30C6              * 3/10/89      Mensch (and Dave)
0998 30C6              *              Changed the "thin rect" stuff to allow use to call
0999 30C6              *              some new super slab routines
1000 30C6              *
1001 30C6              * 4/22/89      Mensch
1002 30C6              *              Fixed all super slab (non-slabs actually) to take
1003 30C6              *              the proper word of the pattern for screen blitting
1004 30C6              *
1005 30C6              ****************************************************************
1006 30C6
1007 30C6              iDrawRectB PROC EXPORT 
1008 30C6
1009 30C6              ;---------------------------------------------------------------
1010 30C6                       EXPORT iDrawRect 
1011 30C6                       IMPORT  FastDrawRect 
1012 30C6              ;---------------------------------------------------------------
1013 30C6
1014 30C6              ;---------------------------------------------------------------
1015 30C6 22 90 1E E0           jsl   BMakeMinRect
1016 30CA 20 88 4D              jsr   MinRectToY1
1017 30CD 90 01                 bcc   iDrawRect
1018 30CF 6B                    rtl   
1019 30D0              ;---------------------------------------------------------------
1020 30D0 8B           iDrawRect phb                           ;save the data bank register
1021 30D1
1022 30D1 A7 54                 lda   [RgnPtrA]
1023 30D3 07 64                 ora   [RgnPtrB]
1024 30D5 C9 0A 00              cmp   #10
1025 30D8 D0 08                 bne   GoSlow
1026 30DA 64 A4                 stz   NonRectRegions
1027 30DC 22 E8 1E E0           jsl   SetSlabAdr
1028 30E0 90 2A                 bcc   FastDrawRect
1029 30E2              ;---------------------------------------------------------------
1030 30E2 22 C0 1E E0  GoSlow   jsl   Init2Regions
1031 30E6 22 E8 1E E0           jsl   SetSlabAdr
1032 30EA 22 70 1E E0           jsl   XSetup
1033 30EE
1034 30EE 20 47 34              jsr   SetFirstDestRef          ;set up dest ref for first scan line
1035 30F1
1036 30F1 20 C5 34     RectLoop jsr   NextPatSlice             	;set up the next pattern slice
1037 30F4 22 CC 1E E0           jsl   Seek2Regions             	;seek regions to this line
1038 30F8
1039 30F8 22 00 1E E0           jsl   ToSlab                   	;draw this slab
1040 30FC
1041 30FC A5 40                 lda   CurrentY                 	;bump current Y
1042 30FE 1A                    inc   a
1043 30FF C5 AA                 cmp   Y2
1044 3101 10 07                 bpl   TheEnd
1045 3103 85 40                 sta   CurrentY
1046 3105
1047 3105 20 F4 34              jsr   SetNextDestRef
1048 3108 80 E7                 bra   RectLoop
1049 310A
1050 310A AB           TheEnd   plb                            ;restore the bank register
1051 310B 6B                    rtl   
1052 310C              ;---------------------------------------------------------------
1053 310C
1054 310C                       ENDP 
1055 310C
1056 310C              ****************************************************************
1057 310C
1058 310C              FastDrawRect PROC 
1059 310C
1060 310C              ;---------------------------------------------------------------
1061 310C                       IMPORT  EndXORRazor 
1062 310C                       IMPORT  CopyJumpTable 
1063 310C              ;---------------------------------------------------------------
1064 310C
1065 310C              ;---------------------------------------------------------------
1066 310C              patIndex equ   CurrentY
1067 310C              lineCount equ   Y2
1068 310C              ;---------------------------------------------------------------
1069 310C
1070 310C              ;---------------------------------------------------------------
1071 310C 22 70 1E E0           jsl   XSetup                   	;setup for calling the slabs
1072 3110 20 47 34              jsr   SetFirstDestRef
1073 3113
1074 3113 D4 AA                 pei   Y2                       	;save Y2
1075 3115
1076 3115 A5 AA                 lda   Y2                       	;find the line count (bottom - top)
1077 3117 38                    sec   
1078 3118 E5 40                 sbc   CurrentY
1079 311A 85 AA                 sta   lineCount
1080 311C
1081 311C A5 B6                 lda   FillMode                 	;if the fill mode is not modeCopy
1082 311E 29 7F 00              and   #$7F                     	;..or modeXOR, then use the slabs
1083 3121 F0 05                 beq   @1
1084 3123 C9 02 00              cmp   #modeXOR
1085 3126 D0 25                 bne   useTheSlabs
1086 3128              @1        
1087 3128 A5 C6                 lda   FinishWord               	;If we are only doing one or two words,
1088 312A 38                    sec                            	;..then special case these
1089 312B E5 C4                 sbc   StartWord
1090 312D F0 64                 beq   doSingle
1091 312F 4A                    lsr   a
1092 3130 3A                    dec   a
1093 3131 F0 17                 beq   @gotoEdges
1094 3133 C9 50 00              cmp   #80                      	;if we are using more than 80 words then
1095 3136 B0 15                 bge   useTheSlabs              	;..use the slabs
1096 3138 85 2A                 sta   Temp                     	;save the count in direct page
1097 313A
1098 313A A2 00 02              ldx   #512                     	;if we are using solid patterns then
1099 313D B5 EC                 lda   <DirtyDPFlags,x          ;..do a special loop
1100 313F 29 00 08              and   #SolidPatOK
1101 3142 C9 00 08              cmp   #SolidPatOK
1102 3145 D0 06                 bne   useTheSlabs
1103 3147
1104 3147 4C 4E 33              jmp   fastMiddle
1105 314A 4C 5B 32     @gotoEdges jmp   doEdges
1106 314D              ;---------------------------------------------------------------
1107 314D
1108 314D
1109 314D
1110 314D
1111 314D              ;---------------------------------------------------------------
1112 314D 20 09 34     useTheSlabs jsr   makePatIndex          	;find the index into the FillPat table
1113 3150
1114 3150 B5 0E        @loop    lda   TheFillPat,x             	;put the pattern in Pat
1115 3152 85 CA                 sta   Pat
1116 3154 B5 10                 lda   TheFillPat+2,x
1117 3156 85 CC                 sta   Pat+2
1118 3158
1119 3158 A5 B6                 lda   FillMode                 	;do we need to invert the pattern ?
1120 315A 10 0E                 bpl   @notNOT
1121 315C A5 CA                 lda   Pat
1122 315E 49 FF FF              eor   #$FFFF
1123 3161 85 CA                 sta   Pat
1124 3163 A5 CC                 lda   Pat+2
1125 3165 49 FF FF              eor   #$FFFF
1126 3168 85 CC                 sta   Pat+2
1127 316A              @notNOT   
1128 316A 22 00 1E E0           jsl   ToSlab                   	;draw the actual line
1129 316E
1130 316E C6 AA                 dec   lineCount
1131 3170 F0 1C                 beq   allDone
1132 3172
1133 3172 A5 40                 lda   patIndex                 	;move to the next pattern
1134 3174 18                    clc   
1135 3175 69 04 00              adc   #4
1136 3178 29 1F 01              and   #$011F
1137 317B 85 40                 sta   patIndex
1138 317D AA                    tax   
1139 317E
1140 317E A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1141 3180 65 12                 adc   Width                    	;..always clear here
1142 3182 85 BC                 sta   DestRef
1143 3184 90 CA                 bcc   @loop
1144 3186
1145 3186 E6 BE                 inc   DestRef+2
1146 3188 D4 BD                 pei   DestRef+1
1147 318A AB                    plb   
1148 318B AB                    plb   
1149 318C 80 C2                 bra   @loop
1150 318E              ;---------------------------------------------------------------
1151 318E 68           allDone  pla   
1152 318F 85 AA                 sta   Y2
1153 3191 AB                    plb   
1154 3192 6B                    rtl   
1155 3193              ;---------------------------------------------------------------
1156 3193
1157 3193
1158 3193
1159 3193
1160 3193              ;---------------------------------------------------------------
1161 3193 A2 00 02     doSingle ldx   #512                     	;if we are using solid patterns then
1162 3196 B5 EC                 lda   <DirtyDPFlags,x          ;..do a special loop
1163 3198 29 00 08              and   #SolidPatOK
1164 319B C9 00 08              cmp   #SolidPatOK
1165 319E D0 64                 bne   slowSingle
1166 31A0
1167 31A0 A2 00 01              ldx   #256
1168 31A3 B5 0E                 lda   TheFillPat,x
1169 31A5 85 CA                 sta   Pat
1170 31A7 A6 B6                 ldx   FillMode
1171 31A9 10 05                 bpl   @notNOT
1172 31AB 49 FF FF              eor   #$FFFF
1173 31AE 85 CA                 sta   Pat
1174 31B0              @notNOT   
1175 31B0 A4 C4                 ldy   StartWord                	;our offset stays the same
1176 31B2 A6 AA                 ldx   lineCount
1177 31B4
1178 31B4 A5 B6                 lda   FillMode                 	;..copy or an XOR
1179 31B6 29 7F 00              and   #$7F
1180 31B9 F0 22                 beq   singleCopy
1181 31BB              ;---------------------------------------------------------------
1182 31BB A5 CA        singleXOR lda   Pat                     	;combine the pattern with the mask
1183 31BD 25 A0                 and   LeftMask
1184 31BF 25 A2                 and   RightMask
1185 31C1 85 CA                 sta   Pat
1186 31C3
1187 31C3 18           @slowLoop clc                           	;clear the carry
1188 31C4 A5 CA        @loop    lda   Pat
1189 31C6 51 BC                 eor   (DestRef),y
1190 31C8 91 BC                 sta   (DestRef),y
1191 31CA CA                    dex   
1192 31CB F0 C1                 beq   AllDone
1193 31CD A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1194 31CF 65 12                 adc   Width                    	;..always clear here
1195 31D1 85 BC                 sta   DestRef
1196 31D3 90 EF                 bcc   @loop
1197 31D5 E6 BE                 inc   DestRef+2
1198 31D7 D4 BD                 pei   DestRef+1
1199 31D9 AB                    plb   
1200 31DA AB                    plb   
1201 31DB 80 E6                 bra   @slowLoop
1202 31DD              ;---------------------------------------------------------------
1203 31DD A5 A0        singleCopy lda   LeftMask               	;combine our masks so we only need one
1204 31DF 25 A2                 and   RightMask
1205 31E1 85 A0                 sta   LeftMask
1206 31E3
1207 31E3 18           @slowLoop clc                           	;clear the carry
1208 31E4 A5 CA        @loop    lda   Pat
1209 31E6 51 BC                 eor   (DestRef),y
1210 31E8 25 A0                 and   LeftMask
1211 31EA 51 BC                 eor   (DestRef),y
1212 31EC 91 BC                 sta   (DestRef),y
1213 31EE CA                    dex   
1214 31EF F0 10                 beq   gotoAllDone1
1215 31F1 A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1216 31F3 65 12                 adc   Width                    	;..always clear here
1217 31F5 85 BC                 sta   DestRef
1218 31F7 90 EB                 bcc   @loop
1219 31F9 E6 BE                 inc   DestRef+2
1220 31FB D4 BD                 pei   DestRef+1
1221 31FD AB                    plb   
1222 31FE AB                    plb   
1223 31FF 80 E2                 bra   @slowLoop
1224 3201 4C 8E 31     gotoAllDone1 jmp   AllDone
1225 3204              ;---------------------------------------------------------------
1226 3204 20 09 34     slowSingle jsr   makePatIndex           	;find the index into the FillPat table
1227 3207              ; 4/22/89 Mensch
1228 3207              ; Modified to support 32 byte patterns
1229 3207 A5 C4                 lda   <STartWord
1230 3209 29 02 00              and   #$0002
1231 320C F0 02                 beq   @1
1232 320E E8                    inx                            ; if odd bump pattern address by 2...
1233 320F E8                    inx   
1234 3210              @1        
1235 3210 A5 A0                 lda   LeftMask                 	;combine our masks so we only need one
1236 3212 25 A2                 and   RightMask
1237 3214 85 A0                 sta   LeftMask
1238 3216 64 CC                 stz   Pat+2                    	;use Pat+2 to take care of the not mode
1239 3218 A5 B6                 lda   FillMode                 	;..for the pattern
1240 321A 10 02                 bpl   @notNOT
1241 321C C6 CC                 dec   Pat+2
1242 321E              @notNOT   
1243 321E A4 C4                 ldy   StartWord                	;our offset stays the same
1244 3220
1245 3220 64 2A                 stz   Temp                     	;temp tells us whether we are doing a
1246 3222 A5 B6                 lda   FillMode                 	;..copy or an XOR
1247 3224 29 7F 00              and   #$7F
1248 3227 F0 02                 beq   @slowLoop
1249 3229 C6 2A                 dec   Temp                     	;here we are doing an XOR
1250 322B
1251 322B 18           @slowLoop clc   
1252 322C B5 0E        @loop    lda   TheFillPat,x             	;put the pattern in Pat
1253 322E 45 CC                 eor   Pat+2                    	;take care of the NOT case
1254 3230 24 2A                 bit   Temp
1255 3232 30 02                 bmi   @2
1256 3234 51 BC                 eor   (DestRef),y
1257 3236 25 A0        @2       and   LeftMask
1258 3238 51 BC                 eor   (DestRef),y
1259 323A 91 BC                 sta   (DestRef),y
1260 323C
1261 323C C6 AA                 dec   lineCount
1262 323E F0 18                 beq   gotoAllDone
1263 3240
1264 3240 8A                    txa                            ;move to the next pattern
1265 3241 69 04 00              adc   #4                       	;carry is ALWAYS clear here
1266 3244 29 1F 01              and   #$011F
1267 3247 AA                    tax   
1268 3248
1269 3248 A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1270 324A 65 12                 adc   Width                    	;..always clear here
1271 324C 85 BC                 sta   DestRef
1272 324E 90 DC                 bcc   @loop
1273 3250
1274 3250 E6 BE                 inc   DestRef+2
1275 3252 D4 BD                 pei   DestRef+1
1276 3254 AB                    plb   
1277 3255 AB                    plb   
1278 3256 80 D3                 bra   @slowLoop
1279 3258              ;---------------------------------------------------------------
1280 3258 4C 8E 31     gotoAllDone jmp   allDone
1281 325B              ;---------------------------------------------------------------
1282 325B
1283 325B
1284 325B
1285 325B
1286 325B              ;---------------------------------------------------------------
1287 325B              doEdges   
1288 325B A2 00 02              ldx   #512                     	;if we are using solid patterns then
1289 325E B5 EC                 lda   <DirtyDPFlags,x          ;..do a special loop
1290 3260 29 00 08              and   #SolidPatOK
1291 3263 C9 00 08              cmp   #SolidPatOK
1292 3266 D0 75                 bne   slowEdges
1293 3268
1294 3268 A2 00 01              ldx   #256
1295 326B B5 0E                 lda   TheFillPat,x
1296 326D 85 CA                 sta   Pat
1297 326F
1298 326F A6 B6                 ldx   FillMode
1299 3271 10 05                 bpl   @notNOT
1300 3273 49 FF FF              eor   #$FFFF
1301 3276 85 CA                 sta   Pat
1302 3278              @notNOT   
1303 3278 A6 AA                 ldx   lineCount
1304 327A
1305 327A A5 B6                 lda   FillMode                 	;..copy or an XOR
1306 327C 29 7F 00              and   #$7F
1307 327F F0 30                 beq   edgeCopy
1308 3281              ;---------------------------------------------------------------
1309 3281 A5 CA        edgeXOR  lda   Pat
1310 3283 A8                    tay   
1311 3284 25 A0                 and   LeftMask
1312 3286 85 CA                 sta   Pat
1313 3288 98                    tya   
1314 3289 25 A2                 and   RightMask
1315 328B 85 CC                 sta   Pat+2
1316 328D
1317 328D 18           @slowLoop clc   
1318 328E A4 C4        @loop    ldy   StartWord
1319 3290 A5 CA                 lda   Pat
1320 3292 51 BC                 eor   (DestRef),y
1321 3294 91 BC                 sta   (DestRef),y
1322 3296 C8                    iny   
1323 3297 C8                    iny   
1324 3298 A5 CC                 lda   Pat+2
1325 329A 51 BC                 eor   (DestRef),y
1326 329C 91 BC                 sta   (DestRef),y
1327 329E CA                    dex   
1328 329F F0 B7                 beq   gotoAllDone
1329 32A1 A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1330 32A3 65 12                 adc   Width                    	;..always clear here
1331 32A5 85 BC                 sta   DestRef
1332 32A7 90 E5                 bcc   @loop
1333 32A9 E6 BE                 inc   DestRef+2
1334 32AB D4 BD                 pei   DestRef+1
1335 32AD AB                    plb   
1336 32AE AB                    plb   
1337 32AF 80 DC                 bra   @slowLoop
1338 32B1              ;---------------------------------------------------------------
1339 32B1 18           edgeCopy clc   
1340 32B2 A4 C4        @loop    ldy   StartWord
1341 32B4 A5 CA                 lda   Pat
1342 32B6 51 BC                 eor   (DestRef),y
1343 32B8 25 A0                 and   LeftMask
1344 32BA 51 BC                 eor   (DestRef),y
1345 32BC 91 BC                 sta   (DestRef),y
1346 32BE C8                    iny   
1347 32BF C8                    iny   
1348 32C0 A5 CA                 lda   Pat
1349 32C2 51 BC                 eor   (DestRef),y
1350 32C4 25 A2                 and   RightMask
1351 32C6 51 BC                 eor   (DestRef),y
1352 32C8 91 BC                 sta   (DestRef),y
1353 32CA CA                    dex   
1354 32CB F0 8B                 beq   gotoAllDone
1355 32CD A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1356 32CF 65 12                 adc   Width                    	;..always clear here
1357 32D1 85 BC                 sta   DestRef
1358 32D3 90 DD                 bcc   @loop
1359 32D5 E6 BE                 inc   DestRef+2
1360 32D7 D4 BD                 pei   DestRef+1
1361 32D9 AB                    plb   
1362 32DA AB                    plb   
1363 32DB 80 D4                 bra   edgeCopy
1364 32DD              ;---------------------------------------------------------------
1365 32DD 20 09 34     slowEdges jsr   makePatIndex            	;find the index into the FillPat table
1366 32E0
1367 32E0 64 2A                 stz   Temp                     	;temp tells us whether we are doing a
1368 32E2 A5 B6                 lda   FillMode                 	;..copy or an XOR
1369 32E4 29 7F 00              and   #$7F
1370 32E7 F0 02                 beq   @slowLoop
1371 32E9 C6 2A                 dec   Temp                     	;here we are doing an XOR
1372 32EB
1373 32EB 18           @slowLoop clc   
1374 32EC A5 C4        @loop    lda   StartWord                ; Modified 4/22/89 mensch
1375 32EE A8                    tay                            ; make this change to support 32 byte patterns
1376 32EF 29 02 00              and   #$0002
1377 32F2 F0 08                 beq   @EvenPat                 ; if zero use pats in order
1378 32F4 B5 0E                 lda   TheFillPat,x             ; else swap em...
1379 32F6 85 CC                 sta   Pat+2                    ; first store the 2nd word pattern
1380 32F8 B5 10                 lda   TheFillPat+2,x
1381 32FA 80 06                 bra   @OddPat
1382 32FC              @EvenPat  
1383 32FC B5 10                 lda   TheFillPat+2,x           ; store the 2nd word pattern
1384 32FE 85 CC                 sta   Pat+2
1385 3300 B5 0E                 lda   TheFillPat,x             ;Now get first word pat
1386 3302 24 B6        @OddPat  bit   FillMode
1387 3304 10 03                 bpl   @notNOT1
1388 3306 49 FF FF              eor   #$FFFF
1389 3309 24 2A        @notNOT1 bit   Temp
1390 330B 30 02                 bmi   @1
1391 330D 51 BC                 eor   (DestRef),y
1392 330F 25 A0        @1       and   LeftMask
1393 3311 51 BC                 eor   (DestRef),y
1394 3313 91 BC                 sta   (DestRef),y
1395 3315 C8                    iny   
1396 3316 C8                    iny   
1397 3317 A5 CC                 lda   Pat+2                    ;put the pattern in Pat
1398 3319 24 B6                 bit   FillMode
1399 331B 10 03                 bpl   @notNOT2
1400 331D 49 FF FF              eor   #$FFFF
1401 3320 24 2A        @notNOT2 bit   Temp
1402 3322 30 02                 bmi   @2
1403 3324 51 BC                 eor   (DestRef),y
1404 3326 25 A2        @2       and   RightMask
1405 3328 51 BC                 eor   (DestRef),y
1406 332A 91 BC                 sta   (DestRef),y
1407 332C
1408 332C C6 AA                 dec   lineCount
1409 332E F0 1B                 beq   edgeDone
1410 3330
1411 3330 A5 40                 lda   patIndex                 	;move to the next pattern
1412 3332 69 04 00              adc   #4                       	;carry is ALWAYS clear here
1413 3335 29 1F 01              and   #$011F
1414 3338 85 40                 sta   patIndex
1415 333A AA                    tax   
1416 333B
1417 333B A5 BC                 lda   DestRef                  	;move to the next line. NOTE: carry is
1418 333D 65 12                 adc   Width                    	;..always clear here
1419 333F 85 BC                 sta   DestRef
1420 3341 90 A9                 bcc   @loop
1421 3343
1422 3343 E6 BE                 inc   DestRef+2
1423 3345 D4 BD                 pei   DestRef+1
1424 3347 AB                    plb   
1425 3348 AB                    plb   
1426 3349 80 A0                 bra   @slowLoop
1427 334B              ;---------------------------------------------------------------
1428 334B 4C 8E 31     edgeDone jmp   allDone
1429 334E              ;---------------------------------------------------------------
1430 334E
1431 334E              ;---------------------------------------------------------------
1432 334E A2 00 01     fastMiddle ldx   #256                   	;if we are using extended patterns, then
1433 3351 B5 0E                 lda   TheFillPat,x             	;..call the slabs
1434 3353 85 CA                 sta   Pat
1435 3355 D5 10                 cmp   TheFillPat+2,x
1436 3357 F0 03 82 F1           bnel useTheSlabs
1437 335C
1438 335C A6 B6                 ldx   FillMode                 	;do we need to invert the pattern ?
1439 335E 10 05                 bpl   @dontInvert
1440 3360 49 FF FF              eor   #$FFFF
1441 3363 85 CA                 sta   Pat
1442 3365
1443 3365 8A           @dontInvert txa                         ;get back the fill mode
1444 3366 29 7F 00              and   #$7F
1445 3369 F0 0F                 beq   @setupCopy
1446 336B
1447 336B A5 2A        @setupXOR lda   Temp
1448 336D 0A                    asl   a                        	;multiply the count by seven (the number
1449 336E 0A                    asl   a                        	;..of bytes of code it takes to XOR one
1450 336F 0A                    asl   a                        	;..word.)
1451 3370 E5 2A                 sbc   Temp                     	;NOTE: the carry is always CLR here so
1452 3372 49 FF FF              eor   #$FFFF                   	;..these three lines get us:
1453 3375 69 23 2A              adc   #EndXORRazor-2           	;..{ EndXORRazor - (count * 7) - 1 }
1454 3378 80 09                 bra   @cont
1455 337A
1456 337A A5 2A        @setupCopy lda   Temp
1457 337C 0A                    asl   a
1458 337D AA                    tax   
1459 337E BF EA 2B FE           lda   >CopyJumpTable,x
1460 3382 3A                    dec   a
1461 3383
1462 3383 85 2A        @cont    sta   Temp                     	;save the jump address for the slab hooks
1463 3385 D4 C6                 pei   FinishWord               	;save FinishWord, since we kill it
1464 3387 A6 CA                 ldx   Pat                      	;keep the pattern in the X-Reg
1465 3389
1466 3389 A5 C6                 lda   FinishWord               	;adjust the finish word so we can use it
1467 338B 38                    sec                            	;..as an index easier
1468 338C E5 C4                 sbc   StartWord
1469 338E 85 C6                 sta   FinishWord
1470 3390 A5 C4                 lda   StartWord                	;make Y-Reg a pointer to the first word
1471 3392 18                    clc                            	;..to invert
1472 3393 65 BC                 adc   DestRef
1473 3395 A8                    tay   
1474 3396 A5 B6                 lda   FillMode                 	;are we using copy or XOR ?
1475 3398 29 7F 00              and   #$7F
1476 339B F0 2C                 beq   @enterCopyLoop
1477 339D 80 59                 bra   @enterXORLoop
1478 339F              ;---------------------------------------------------------------
1479 339F 8A           @copyLoop txa   
1480 33A0 59 00 00              eor   |0,y
1481 33A3 25 A0                 and   LeftMask
1482 33A5 59 00 00              eor   |0,y
1483 33A8 99 00 00              sta   |0,y
1484 33AB 84 BC                 sty   DestRef                  	;save our index in DestRef
1485 33AD A4 C6                 ldy   FinishWord               	;the last word is always at finish word
1486 33AF 8A                    txa                            	;source pattern is still in X-Reg
1487 33B0 51 BC                 eor   (DestRef),y
1488 33B2 25 A2                 and   RightMask
1489 33B4 51 BC                 eor   (DestRef),y
1490 33B6 91 BC                 sta   (DestRef),y              	;and store
1491 33B8 A4 BC                 ldy   DestRef
1492 33BA
1493 33BA 8A                    txa                            	;copy needs the pattern in the A-Reg
1494 33BB F4 C0 33              pea   @backHere1-1
1495 33BE D4 2A                 pei   Temp
1496 33C0 60                    rts   
1497 33C1 C6 AA        @backHere1 dec   lineCount
1498 33C3 F0 3E                 beq   middleDone
1499 33C5 98                    tya                            	;the carry is always clear here
1500 33C6 65 12                 adc   Width
1501 33C8 A8                    tay   
1502 33C9 90 D4        @enterCopyLoop bcc   @copyLoop
1503 33CB 18                    clc                            	;the carry must remain clear thru this
1504 33CC E6 BE                 inc   DestRef+2                	;..loop
1505 33CE D4 BD                 pei   DestRef+1
1506 33D0 AB                    plb   
1507 33D1 AB                    plb   
1508 33D2 80 CB                 bra   @copyLoop
1509 33D4              ;---------------------------------------------------------------
1510 33D4 8A           @XORLoop txa                            	;invert our first word using the only
1511 33D5 25 A0                 and   LeftMask                 	;..pattern and leftMask
1512 33D7 59 00 00              eor   |0,y
1513 33DA 99 00 00              sta   |0,y
1514 33DD 84 BC                 sty   DestRef                  	;save our index in DestRef
1515 33DF A4 C6                 ldy   FinishWord               	;the last word is always at finish word
1516 33E1 8A                    txa                            	;source pattern is still in X-Reg
1517 33E2 25 A2                 and   RightMask
1518 33E4 51 BC                 eor   (DestRef),y
1519 33E6 91 BC                 sta   (DestRef),y              	;and store
1520 33E8 A4 BC                 ldy   DestRef
1521 33EA
1522 33EA F4 EF 33              pea   @backHere2-1             	;pattern in A-Reg; XOR needs it in X-Reg
1523 33ED D4 2A                 pei   Temp
1524 33EF 60                    rts   
1525 33F0 C6 AA        @backHere2 dec   lineCount
1526 33F2 F0 0F                 beq   middleDone
1527 33F4 98                    tya   
1528 33F5 65 12                 adc   Width                    	;the carry is always clear here
1529 33F7 A8                    tay   
1530 33F8 90 DA        @enterXORLoop bcc   @XORLoop
1531 33FA 18                    clc                            	;the carry must remain clear thru this
1532 33FB E6 BE                 inc   DestRef+2                	;..loop
1533 33FD D4 BD                 pei   DestRef+1
1534 33FF AB                    plb   
1535 3400 AB                    plb   
1536 3401 80 D1                 bra   @XORLoop
1537 3403              ;---------------------------------------------------------------
1538 3403 68           middleDone pla   
1539 3404 85 C6                 sta   FinishWord
1540 3406 4C 8E 31              jmp   allDone
1541 3409              ;---------------------------------------------------------------
1542 3409
1543 3409
1544 3409
1545 3409              ;---------------------------------------------------------------
1546 3409 A5 40        makePatIndex lda   CurrentY             	;find the current index into the FillPat
1547 340B 29 07 00              and   #7                       	;..table
1548 340E 0A                    asl   a
1549 340F 0A                    asl   a
1550 3410 69 00 01              adc   #256
1551 3413 85 40                 sta   patIndex
1552 3415 AA                    tax   
1553 3416 60                    rts   
1554 3417              ;---------------------------------------------------------------
1555 3417
1556 3417                       ENDP 
1557 3417
1558 3417              ****************************************************************
1559 3417
1560 3417              ****************************************************************
1561 3417              *
1562 3417              * CheckPenVis
1563 3417              *
1564 3417              * This routine makes sure that the pen is visible. It is called
1565 3417              * as quickly as possible after the bottle neck proc so if the
1566 3417              * pen is not visible, we can quit fast.
1567 3417              *
1568 3417              * If the pen is not visible, then we perform the RTL for the
1569 3417              * calling routine.
1570 3417              *
1571 3417              * Modification History
1572 3417              *
1573 3417              * 19 May 86    When pen is not visible we must
1574 3417              *              clear carry and zero accumulator so proper
1575 3417              *              error is propagated.
1576 3417              *
1577 3417              * 3/9/89       Mensch
1578 3417              * Added adjustment of DirtyDPFlags to this routine...
1579 3417              *
1580 3417              ****************************************************************
1581 3417              CheckPenVis PROC EXPORT 
1582 3417 A0 72 00              ldy   #o_PnVis
1583 341A B7 24                 lda   [PortRef],y
1584 341C 30 0B                 bmi   NotVisible
1585 341E A2 00 02              ldx   #512
1586 3421 B5 EC                 lda   <DirtyDPFlags,x
1587 3423 09 01 00              ora   #PenVisOK
1588 3426 95 EC                 sta   <DirtyDPFlags,x
1589 3428 60                    rts   
1590 3429
1591 3429 68           NotVisible pla                          ; pull rts adr off stack
1592 342A 18                    clc                            ; clear carry and a-reg so no
1593 342B A9 00 00              lda   #0                       ; error is returned.
1594 342E 6B                    rtl                            ; do rtl for caller.
1595 342F
1596 342F                       ENDP 
1597 342F
1598 342F
1599 342F              ****************************************************************
1600 342F              *
1601 342F              * GrabPenSize
1602 342F              *
1603 342F              * Get the PnSize from the port and puts it in LocalPnSize.
1604 342F              * It also checks to see if either is 0.  If it is then
1605 342F              * we do an rtl for the calling routine.
1606 342F              *
1607 342F              * Modification History
1608 342F              *
1609 342F              * 19 May 86    When pen size is less than one then we must
1610 342F              *              clear carry and zero accumulator so proper
1611 342F              *              error is propagated.
1612 342F              *
1613 342F              ****************************************************************
1614 342F              GrabPenSize PROC EXPORT 
1615 342F
1616 342F A0 44 00              ldy   #O_PnSize
1617 3432 B7 24                 lda   [PortRef],y
1618 3434 F0 0B                 beq   NowWaitAMin
1619 3436 85 B8                 sta   LocalPnSize
1620 3438 C8                    iny   
1621 3439 C8                    iny   
1622 343A B7 24                 lda   [PortRef],y
1623 343C F0 03                 beq   NowWaitAMin
1624 343E 85 BA                 sta   LocalPnSize+2
1625 3440
1626 3440 60                    rts   
1627 3441
1628 3441 68           NowWaitAMin pla                         ; get rts adr off stack
1629 3442 18                    clc                            ; remember that this terminates call
1630 3443 A9 00 00              lda   #0                       ; with no error
1631 3446 6B                    rtl                            ; do rtl for calling routine
1632 3447
1633 3447                       ENDP 
1634 3447
1635 3447
1636 3447              *********************************************************************
1637 3447              *
1638 3447              * SetFirstDestRef
1639 3447              *
1640 3447              * History
1641 3447              * 8/4/87       GCP          Installed patch version of this routine
1642 3447              *
1643 3447              * 2/25/89      Mensch
1644 3447              * Added a faster inline multiply just for grins. Speed this routine up
1645 3447              * quite a lot and seems to complement those new faster rectangles pretty
1646 3447              * well.
1647 3447              *********************************************************************
1648 3447
1649 3447              SetFirstDestRef PROC EXPORT 
1650 3447              Mult1    equ   DestRef
1651 3447              Mult2    equ   DestRef+2
1652 3447
1653 3447 F4 00 00              pea   0                        ;assume its positive
1654 344A A5 A6                 lda   Y1                       ;now figure out where in the
1655 344C 85 40                 sta   CurrentY                 ;pixel map this scan line
1656 344E 38                    sec                            ;is
1657 344F E5 14                 sbc   BoundsRect
1658 3451
1659 3451
1660 3451 10 06                 bpl   ItsPositive
1661 3453
1662 3453 83 01                 sta   1,s
1663 3455 49 FF FF              eor   #$FFFF
1664 3458 1A                    inc   a
1665 3459
1666 3459              ItsPositive  
1667 3459              ; since we are resetting destref, lets have some fun and use it for a temp
1668 3459              ; Comming into this loop <A> contains the scan line number
1669 3459              ; so we first see if we rolled off the "Dave" limit
1670 3459 85 BC                 sta   Mult1                    ; lets save it for a sec as an operand.....
1671 345B C9 90 01              cmp   #400                     ; see if we rolled over the top of the mult below
1672 345E B0 1B                 bge   @DoMultSlow
1673 3460 A5 12                 lda   <Width
1674 3462 C9 A0 00              cmp   #$00A0                   ; is it scan line size???
1675 3465 D0 14                 bne   @DoMultSlow
1676 3467 A5 BC                 lda   Mult1                    ; get our number back...
1677 3469 0A                    asl   a                        ; multiply it by 32 first..
1678 346A 0A                    asl   a
1679 346B 0A                    asl   a
1680 346C 0A                    asl   a
1681 346D 0A                    asl   a
1682 346E 85 BC                 sta   Mult1
1683 3470 0A                    asl   a
1684 3471 0A                    asl   a
1685 3472 18                    clc   
1686 3473 65 BC                 adc   Mult1
1687 3475 F4 00 00              pea   0
1688 3478 48                    pha   
1689 3479 80 23                 bra   @DoMultDone
1690 347B              @DoMultSlow  
1691 347B              ;
1692 347B              ; the damned fast multiply that I put in fails on enormous drawings (Damn)
1693 347B              ; so, we put back the old multiply routine so we can ship the damned disk!
1694 347B              ; Mensch 6/13/89
1695 347B 48                    pha   
1696 347C 48                    pha   
1697 347D D4 BC                 pei   Mult1
1698 347F D4 12                 pei   Width
1699 3481 A2 0B 09 22           _Multiply 
1700 3488 80 14                 bra   @DoMultDone
1701 348A 00 00 00 00           DC B:0,0,0,0,0,0,0,0,0,0
1702 3494 00 00 00 00           DC B:0,0,0,0,0,0,0,0,0,0
1703 349E
1704 349E              ;
1705 349E              ; Fast multiply routine, just in case I need it for something!
1706 349E              ;
1707 349E              ;	ldx	#0	; init our carry over area
1708 349E              ;	lda	#0
1709 349E              ;@dm0010	lsr	Mult1	; shift for first test
1710 349E              ;	beq	@dmLastOne	; handle the last multiply
1711 349E              ;	bcc	@dm0020
1712 349E              ;	clc
1713 349E              ;	adc	Mult2
1714 349E              ;	bcc	@dm0020	; if carry clear we didn't role the bank yet..
1715 349E              ;	inx		; if carry set, role the bank!
1716 349E              ;@dm0020	asl	Mult2
1717 349E              ;
1718 349E              ; Bug fix here...
1719 349E              ;	bcc	@dm0010
1720 349E              ;	inx
1721 349E              ;	bra	@dm0010
1722 349E              ;@dmLastOne	bcc	@DoMultDone
1723 349E              ;	clc
1724 349E              ;	adc	Mult2
1725 349E              ;	bcc	@DoMultDone	; carry clear no bank role
1726 349E              ;	inx
1727 349E              ;olddoMultDone	phx		; push the high word
1728 349E              ;	pha		; and the low word
1729 349E              @DoMultDone  
1730 349E
1731 349E A3 05                 lda   5,s
1732 34A0 D0 0E                 bne   MustSubtract
1733 34A2
1734 34A2 68                    pla   
1735 34A3 18                    clc   
1736 34A4 65 0E                 adc   ImageRef                 ; low word of image ref
1737 34A6 85 BC                 sta   DestRef                  ;goes into dest ref
1738 34A8 68                    pla   
1739 34A9 65 10                 adc   ImageRef+2               ;hi word of image ref
1740 34AB 29 FF 00              and   #$00FF                   ;mask off higest byte for system wins
1741 34AE 80 0D                 bra   FinishKludge
1742 34B0
1743 34B0              MustSubtract                            ; 
1744 34B0 A5 0E                 lda   ImageRef                 ;subtract result from pointer to image
1745 34B2 38                    sec   
1746 34B3 E3 01                 sbc   1,s
1747 34B5 85 BC                 sta   DestRef
1748 34B7 A5 10                 lda   ImageRef+2
1749 34B9 E3 03                 sbc   3,s
1750 34BB FA                    plx   
1751 34BC FA                    plx   
1752 34BD
1753 34BD 85 BE        FinishKludge sta   DestRef+2
1754 34BF 68                    pla   
1755 34C0
1756 34C0              ;-------------------------------------------------------
1757 34C0              ;
1758 34C0              ; Now set data bank to  bank containing this scan line
1759 34C0              ;
1760 34C0 D4 BD                 pei   DestRef+1
1761 34C2 AB                    plb   
1762 34C3 AB                    plb   
1763 34C4
1764 34C4
1765 34C4 60                    rts   
1766 34C5
1767 34C5
1768 34C5                       ENDP 
1769 34C5
1770 34C5
1771 34C5              ****************************************************************
1772 34C5              *
1773 34C5              * NextPatSlice
1774 34C5              *
1775 34C5              * Using currentY I pull out the correct part of the pattern
1776 34C5              * and draw mask to be drawn.
1777 34C5              *
1778 34C5              *
1779 34C5              * Change History
1780 34C5              *
1781 34C5              * 08 Sep 88	Steven Glass
1782 34C5              *
1783 34C5              * Patterns are always 32 bytes (no matter what the mode).
1784 34C5              *
1785 34C5              ****************************************************************
1786 34C5              NextPatSlice PROC EXPORT 
1787 34C5
1788 34C5 A5 40                 lda   CurrentY
1789 34C7 29 07 00              and   #7                       ; pattern repeats every 8 lines
1790 34CA 0A                    asl   a                        ; pattern 4 bytes wide
1791 34CB 0A                    asl   a
1792 34CC 18                    clc   
1793 34CD 69 00 01              adc   #256
1794 34D0 AA                    tax   
1795 34D1 B5 0E                 lda   TheFillPat,x
1796 34D3 85 CA                 sta   Pat
1797 34D5 B5 10                 lda   TheFillPat+2,x           ; this is wasted in 640 mode but
1798 34D7 85 CC                 sta   Pat+2                    ; not harmful
1799 34D9 B5 2E                 lda   TheDrawMask,x
1800 34DB 85 CE                 sta   DrawMask
1801 34DD B5 30                 lda   TheDrawMask+2,x
1802 34DF 85 D0                 sta   DrawMask+2
1803 34E1
1804 34E1
1805 34E1 A5 B6                 lda   FillMode                 ; if pen mode is a NOT mode, then
1806 34E3 10 0E                 bpl   NotNOT                   ; invert pat
1807 34E5 A5 CA                 lda   Pat
1808 34E7 49 FF FF              eor   #$FFFF
1809 34EA 85 CA                 sta   Pat
1810 34EC A5 CC                 lda   Pat+2
1811 34EE 49 FF FF              eor   #$FFFF
1812 34F1 85 CC                 sta   Pat+2
1813 34F3
1814 34F3              NotNOT                                  ; 
1815 34F3
1816 34F3 60                    rts   
1817 34F4
1818 34F4                       ENDP 
1819 34F4
1820 34F4
1821 34F4              ****************************************************************
1822 34F4              *
1823 34F4              * SetNextDestRef
1824 34F4              *
1825 34F4              * This routine bumps DestRef by width.  It does a full 32 bit
1826 34F4              * add.  If the add carries to the high word it resets the
1827 34F4              * data bank to the new value.
1828 34F4              *
1829 34F4              ****************************************************************
1830 34F4              SetNextDestRef PROC EXPORT 
1831 34F4
1832 34F4 A5 BC                 lda   DestRef
1833 34F6 18                    clc   
1834 34F7 65 12                 adc   Width
1835 34F9 85 BC                 sta   DestRef
1836 34FB B0 01                 bcs   MustCarry
1837 34FD 60                    rts   
1838 34FE
1839 34FE E6 BE        MustCarry inc   DestRef+2
1840 3500 D4 BD                 pei   DestRef+1
1841 3502 AB                    plb   
1842 3503 AB                    plb   
1843 3504 60                    rts   
1844 3505
1845 3505                       ENDP 
1846 3505
1847 3505                       EJECT 
1848 3505                       END   
